from django.db.models import Expression

__all__ = [
    'JsonBuildObject',
]


class JsonBuildObject(Expression):
    template = 'JSON_BUILD_OBJECT(%(expressions)s)'

    def __init__(self, expressions, output_field, **extra):
      super(JsonBuildObject, self).__init__(output_field=output_field)
      for expression in expressions:
          if not hasattr(expression, 'resolve_expression'):
              raise TypeError('%r is not an Expression' % expression)
      self.expressions = expressions
      self.extra = extra

    def resolve_expression(self, query=None, allow_joins=True, reuse=None, summarize=False, for_save=False):
        c = self.copy()
        c.is_summary = summarize
        for pos, expression in enumerate(self.expressions):
            c.expressions[pos] = expression.resolve_expression(query, allow_joins, reuse, summarize)
        return c

    def as_sql(self, compiler, connection):
        sql_expressions, sql_params = [], []
        for expression in self.expressions:
            sql, params = compiler.compile(expression)
            # "By convention, the argument list consists of alternating keys and values"
            sql_expressions.append("'%s'" % expression.target.column)
            sql_expressions.append(sql)
            sql_params.extend(params)
        self.extra['expressions'] = ','.join(sql_expressions)
        return self.template % self.extra, sql_params

    def get_source_expressions(self):
        return self.expressions

    def set_source_expressions(self, expressions):
        self.expressions = expressions

