from django.core import urlresolvers
import urllib

PING_URL = "http://www.google.com/webmasters/sitemaps/ping"

def ping_google():
    sitemap = None
    try:
        # First, try to get the "index" sitemap URL.
        sitemap = urlresolvers.reverse( 'django.contrib.sitemap.views.index' )
    except urlresolvers.NoReverseMatch:
        try:
            # No? Try for the "global" sitemap URL.
            sitemap = urlresolvers.reverse( 'django.contrib.sitemap.views.sitemap' )
        except urlresolvers.NoReverseMatch:
            # Should this raise an exception?
            pass
    if sitemap is not None:
        from django.contrib.sites.models import Site
        current_site = Site.objects.get_current()
        url = "%s%s" % (current_site.domain, sitemap)
        params = urllib.urlencode( {'sitemap':url} )
        urllib.urlopen( "%s?%s" % (PING_URL, params) )

class Sitemap:
    
    def __get( self, name, obj, default=None ):
        try:
            attr = getattr( self, name )
        except AttributeError:
            return default
        if callable( attr ):
            return attr( obj )
        return attr
    
    def items( self ):
        return []
    
    def location( self, obj ):
        return obj.get_absolute_url()
    
    def get_urls( self ):
        from django.contrib.sites.models import Site
        current_site = Site.objects.get_current()
        urls = []
        for item in self.items():
            loc = "http://%s%s" % (current_site.domain, self.__get('location',item))
            url_info = {
                'location':   loc,
                'lastmod':    self.__get('lastmod',item,None),
                'changefreq': self.__get('changefreq',item,None),
                'priority':   self.__get('priority',item,None)
            }
            urls.append( url_info )
        return urls

class FlatpageSitemap (Sitemap):
    
    def items( self ):
        from django.contrib.sites.models import Site
        current_site = Site.objects.get_current()
        return current_site.flatpage_set.all()

class GenericSitemap (Sitemap):
    
    def __init__( self, info_dict ):
        self.queryset = info_dict.get( 'queryset' )
        self.date_field = info_dict.get( 'date_field', None )
    
    def items( self ):
        # Make sure to return a clone; we don't want premature evaluation.
        return self.queryset.filter()
    
    def lastmod( self, item ):
        if self.date_field is not None:
            return getattr( item, self.date_field )
        return None
