from django.contrib.contenttypes.fields import GenericForeignKey, GenericRelation
from django.contrib.contenttypes.models import ContentType
from django.db import models


class Insights(models.Model):
    object_id = models.PositiveIntegerField()
    content_type = models.ForeignKey(ContentType)
    parent_object = GenericForeignKey()
    first_field = models.IntegerField()
    second_field = models.IntegerField()


class ModelA(models.Model):
    name = models.CharField(max_length=40)

    insights = GenericRelation('Insights', related_query_name='a')


class ModelB(models.Model):
    title = models.CharField(max_length=40)

    insights = GenericRelation('Insights', related_query_name='b')
