from django.contrib import admin

# Register your models ahere.
from django import forms

from app.models import Lead


class LeadAdminForm(forms.ModelForm):
    class Meta:
        model = Lead
        fields = ['user_reference', 'state']

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.fields['user_reference'].widget.attrs['data-lead-id'] = self.instance.pk
        self.fields['state'].widget.attrs['data-lead-id'] = self.instance.pk
        self.fields['user_reference'].widget.attrs['disabled'] = 'disabled'
        self.fields['state'].widget.attrs['disabled'] = 'disabled'


class LeadAdmin(admin.ModelAdmin):
    list_display = ['id', 'user_reference', 'state']
    list_editable = ['user_reference', 'state']

    def get_changelist_form(self, request, **kwargs):
        return LeadAdminForm

admin.site.register(Lead, LeadAdmin)
