from django.shortcuts import redirect, render_to_response, render
from django.views.generic.list import ListView
from .models import Events
from .forms import AddEventForm


class EventsListView(ListView):
    model = Events


def new_event(request):
    if request.method == 'POST':
        form = AddEventForm(request.POST)
        if form.is_valid():
            save_data = form.cleaned_data
            handler = Events(event_name=save_data['event_name'], start_date=save_data['start_date'])
            handler.save()
            return redirect('../')
        else:
            form_errors = form.errors
            return render_to_response('events/error.html', {'form_errors': form_errors})

    # if a GET (or any other method) we'll create a blank form
    else:
        form = AddEventForm()
        return render(request, 'events/new_event_form.html', {'form': form})