import re

from django.conf import settings
from django.forms import *


settings.configure(USE_I18N=False)

class TestForm(Form):
    field1 = CharField(label="field1", disabled=True)
    field2 = CharField(label="field2", required=True)

def get_value(form, field):
    " checks if field1 initial value is present "
    p = re.compile('<input id="id_%s"[^>]*value="([^"]*)"[^>]*>' % field)
    match = p.search(str(form))
    if not match:
        return None
    return match.group(1)

if __name__ == '__main__':
    initial_field = 'field1'
    initial_value = 'static'
    initial = {initial_field: initial_value}
    
    # unbound form
    print 'testing unbound form'
    form = TestForm(initial=initial)
    value = get_value(form, initial_field)
    if value == initial_value:
        print '  initial value found in formfield'
    else:
        print '  initial value missing from formfield'
    
    # bound form
    print 'testing bound form'
    data = {}
    form = TestForm(data, initial=initial)
    value = get_value(form, initial_field)
    if value == initial_value:
        print '  initial value found in formfield'
    else:
        print '  initial value missing from formfield'