from django.contrib import admin
from .models import Employee, EmployeeTitle, Title

# Register your models here.
class EmployeeTitleInline(admin.TabularInline):
    model = EmployeeTitle
    extra = 0

@admin.register(Employee)
class EmployeeAdmin(admin.ModelAdmin):
    inlines = (EmployeeTitleInline,)
    list_display = (
        'name',
        'current_title',
    )

@admin.register(Title)
class TitleAdmin(admin.ModelAdmin):
    pass
