from django.db import models

# Create your models here.
class Employee(models.Model):
    name = models.CharField(max_length=20, unique=True)

    def __str__(self):
        return self.name

    def current_title(self):
        return self.employeetitle_set.latest('start_date')
    current_title.admin_order_field = 'employeetitle__title__name'

class EmployeeTitle(models.Model):
    employee = models.ForeignKey('Employee')
    title = models.ForeignKey('Title')
    start_date = models.DateField()
    end_date = models.DateField(null=True, blank=True)

    def __str__(self):
        return self.title.name

class Title(models.Model):
    name = models.CharField(max_length=20, unique=True)

    def __str__(self):
        return self.name
