from datetime import datetime, timedelta

from django.db.models import Count, Q, F
from django.db.models.expressions import Case, When
from django.test import TestCase
from django.utils import timezone

from .models import Article, ArticleLike, ArticleView


class Test(TestCase):
    def test(self):
        a = Article.objects.create(title='foo', pubDate=timezone.now())
        ArticleLike.objects.create(article=a, date=timezone.now())
        ArticleView.objects.create(article=a, date=timezone.now())

        ArticleLike.objects.create(article=a, date=timezone.now() - timedelta(days=1))
        ArticleView.objects.create(article=a, date=timezone.now() - timedelta(days=1))

        b = Article.objects.create(title='foo', pubDate=timezone.now())
        ArticleLike.objects.create(article=b, date=timezone.now())
        ArticleView.objects.create(article=b, date=timezone.now())
        ArticleLike.objects.create(article=b, date=timezone.now())
        ArticleView.objects.create(article=b, date=timezone.now())
        ArticleView.objects.create(article=b, date=timezone.now())

        ArticleLike.objects.create(article=b, date=timezone.now() - timedelta(days=1))
        ArticleView.objects.create(article=b, date=timezone.now() - timedelta(days=1))

        likes = Q()

        qs = Article.objects.annotate(
            likes=Count(
                Case(When(articlelike__date__gte=F('pubDate'), then=F('articlelike__id'))),
                distinct=True
            ),
            views=Count(
                Case(When(articleview__date__gte=F('pubDate'), then=F('articleview__id'))),
                distinct=True
            )
        )
        self.assertEqual(qs[0].likes, 1)
        self.assertEqual(qs[0].views, 1)
        self.assertEqual(qs[1].likes, 2)
        self.assertEqual(qs[1].views, 3)
