import unittest
from django.test import TestCase
from django.contrib.auth.models import User


def test_base(base_cls):
    """Decorator to mark a class as base test class.

    Base test classes are skipped in the test run; only subclasses are included.
    """
    class BaseClassSkipper(base_cls):
        @classmethod
        def setUpClass(cls):
            super(BaseClassSkipper, cls).setUpClass()
            if cls is BaseClassSkipper:
                raise unittest.SkipTest("Base class (%s)" % base_cls.__name__)
    return BaseClassSkipper


@test_base
class Base1(TestCase):
    def test_1(self):
        pass


class Sub1(Base1):
    pass


@test_base
class Base2(TestCase):
    def setUp(self):
        User.objects.create()

    def test_2(self):
        return


class Sub2(Base2):
    pass
