from django.test import TestCase, override_settings, RequestFactory
from django.template import RequestContext


def test_processor(request):
    return {'processors': 'yes'}
test_processor_name = 'template_tests.test_response.test_processor'


@override_settings(
    TEMPLATE_CONTEXT_PROCESSORS=[test_processor_name],
    TEMPLATES=[{
    'BACKEND': 'django.template.backends.django.DjangoTemplates',
    'OPTIONS': {
        'context_processors': [test_processor_name],
    },
}])
class Test(TestCase):
    def test_context_processor(self):
        request = RequestFactory().get('/')
        context = RequestContext(request)
        self.assertEqual(context['processors'], 'yes')
