import timeit
import decimal
from collections import OrderedDict

import django
from django.conf import settings
from django.utils.numberformat import format

settings.configure(USE_L10N=True, LANGUAGE_CODE='en', USE_THOUSAND_SEPARATOR=False)
django.setup()


def do_bench():
    for bench, args in OrderedDict((
        ('Small number, no decimal_pos, no grouping', (
            (100, '.', None, 0, '', False),
            (100.5, '.', None, 0, '', False),
            (decimal.Decimal('100.5'), '.', None, 0, '', False),
            ('100', '.', None, 0, '', False),
            ('100.5', '.', None, 0, '', False),
        )),

        ('Small number, with decimal_pos, no grouping', (
            (10, '.', 2, 0, '', ),
            (10.888, '.', 2, 0, '', ),
            (decimal.Decimal('10.888'), '.', 2, 0, '', ),
            ('10', '.', 2, 0, '', ),
            ('10.888', '.', 2, 0, '', ),
        )),

        ('Small number, no decimal_pos, with grouping', (
            (100, '.', None, 3, ' ', True),
            (100.0123456789, '.', None, 3, ' ', True),
            (decimal.Decimal('-100.0123456789'), '.', None, 3, ' ', True),
            ('-100', '.', None, 3, ' ', True),
            ('-100.0123456789', '.', None, 3, ' ', True),
        )),

        ('No decimal_pos, no grouping', (
            (-1234567890, '.', None, 0, '', False),
            (-1234567890.0123456789, '.', None, 0, '', False),
            (decimal.Decimal('-1234567890.0123456789'), '.', None, 0, '', False),
            ('-1234567890', '.', None, 0, '', False),
            ('-1234567890.0123456789', '.', None, 0, '', False),
        )),

        ('No decimal_pos, with grouping', (
            (-1234567890, '.', None, 3, ' ', True),
            (-1234567890.0123456789, '.', None, 3, ' ', True),
            (decimal.Decimal('-1234567890.0123456789'), '.', None, 3, ' ', True),
            ('-1234567890', '.', None, 3, ' ', True),
            ('-1234567890.0123456789', '.', None, 3, ' ', True),
        )),

        ('With decimal_pos, with grouping', (
            (-1234567890, '.', 2, 3, ' ', True),
            (-1234567890.0123456789, '.', 2, 3, ' '),
            (decimal.Decimal('-1234567890.0123456789'), '.', 2, 3, ' ', True),
            ('-1234567890', '.', 2, 3, ' ', True),
            ('-1234567890.0123456789', '.', 2, 3, ' ', True),
        )),
    )).items():
        print(bench)
        for args in args:
            print('format{!r} -> {}'.format(args, format(*args)))
            print(timeit.repeat('format{!r}'.format(args), setup='from __main__ import format; from decimal import Decimal', number=500000))
        print('')


if __name__ == '__main__':
    do_bench()
