from django.core import meta

class File(meta.Model):
    fields = (
        meta.CharField('name', maxlength=128),
        meta.FileField('data', upload_to="upload"),
        meta.CharField('mimetype', maxlength=256),
        meta.DateTimeField('created', auto_now_add=True),
        meta.DateTimeField('modified', auto_now_add=True),
        meta.TextField('comment')
        )

    admin = meta.Admin()

    def __repr__(self):
        return "File(%s:%s)" % (self.id, self.name)
        
