from django.core.servers.basehttp import app_media_dirs
from os import listdir, sep, mkdir
from os.path import abspath, basename, isdir
from shutil import copy

def list_media_dirs():
    for media_dir in app_media_dirs:
        print media_dir

def sync_media_root():
    from django.conf import settings
    media_file_list = []
    media_dir_list = []
    for media_dir in app_media_dirs:
        files, dirs = tree(media_dir)
        media_file_list = media_file_list + files
        media_dir_list = media_dir_list + dirs
    for dir in media_dir_list:
        idx = dir.index('media')
        rel_media_path = dir[idx+6:]
        new_media_path = settings.MEDIA_ROOT + rel_media_path
        if not isdir(new_media_path):
             print "Creating %s in MEDIA_ROOT" % rel_media_path
             mkdir(new_media_path)
    for file in media_file_list:
        idx = file.index('media')
        rel_media_path = file[idx+6:]
        new_media_path = settings.MEDIA_ROOT + rel_media_path
        print "Syncing %s" % rel_media_path
        copy(file, new_media_path)


def tree(dir):
    files_list = []
    dirs_list = []
    files = []
    files = listdir(dir)
    count = 0
    for file in files:
        if file == '.svn':
            continue
        path = dir + sep + file
        if isdir(path):
            dirs_list.append(abspath(path))
            files, dirs = tree(path)
            files_list = files_list + files
            dirs_list = dirs_list + dirs
        else:
            files_list.append(abspath(path))
    return files_list, dirs_list 
