from django.db import models

class Place(models.Model):
    name = models.CharField(max_length=255)
    telephone = models.CharField(max_length=255)
    email = models.EmailField()

class ProxyPlace(Place):

    class Meta:
        proxy = True

class ChipShop(ProxyPlace):
    chips_price = models.IntegerField()

class IndianRestaurant(Place):
    curry_price = models.IntegerField()