from decimal import Decimal

from django.contrib.auth.models import User
from django.test import TestCase
from django.utils import timezone

from .models import Serving, beer_data_last_n_weeks

class Tests(TestCase):
    def test(self):
        user = User.objects.create(username='foo')
        Serving.objects.create(amount=10, date=timezone.now().date(), type=1, owner=user, location='', cost='10')
        self.assertEqual(
            list(beer_data_last_n_weeks(user, 5)),
            [{'cost': Decimal('10.00'), 'oz': Decimal('10.0'), 'week': 39}]
        )
