"""
Test the django sqlite3 driver to make sure it properly loads/stores unicode

>>> u_data = u'\xc5land islands'
>>> db = DatabaseWrapper()
>>> cur = db.cursor()

We have to make sure we're using the 'real' sqlite cursor, not some
debugcursor
>>> assert isinstance(cur, SQLiteCursorWrapper)

>>> cur.execute("create table foo (blah varchar)")
>>> cur.execute("insert into foo (blah) values (%s)", [u_data])
>>> cur.execute("select * from foo")
>>> assert cur.fetchone()[0] == u_data

"""


from django.db.backends.sqlite3.base import DatabaseWrapper, SQLiteCursorWrapper
import datetime

if __name__ == '__main__':
    import doctest
    doctest.testmod()
