#from django.core.serializers import json
import json
import uuid

from django.core.serializers.json import DjangoJSONEncoder
from django.http import HttpResponse
from django.shortcuts import render
from bug_jsonserializer.models import TestModel
import grappelli.views.related
from django.core import serializers

class OwnDjangoJSONEncoder(DjangoJSONEncoder):
    """
    JSONEncoder subclass that knows how to encode date/time and decimal types.
    """
    def default(self, o):
        if isinstance(o, uuid.UUID):
            return str(o)
        else:
            return super(OwnDjangoJSONEncoder, self).default(o)

def test(request):
    o = TestModel()
    o.save()

    data = [{'pk': o.pk} for o in TestModel.objects.all()]

    #data = json.dumps(data, cls=OwnDjangoJSONEncoder)
    data = json.dumps(data, cls=DjangoJSONEncoder)

    return HttpResponse(data, content_type='application/javascript')
