# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


def update_foo(apps, *args):

    foo = apps.get_model("testapp", 'foo')

    for id, foo in enumerate(foo.objects.all()):
        foo.int_pk = id
        foo.save()

class Migration(migrations.Migration):

    dependencies = [
        ('testapp', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='foo',
            name='int_pk',
            field=models.IntegerField(null=True),
        ),
        migrations.RunPython(
            update_foo,
            lambda *args: None
        )
    ]
