from django.shortcuts import render
import django

# Create your views here.

from . import models


def my_view(request, *args, **kwargs):
    things = models.Thing.objects.all().annotate(
        bar=django.db.models.Case(
            django.db.models.When(
                foo='foo',
                then=django.db.models.Value('bar')
            ),
            default=django.db.models.Value('baz'),
            output_field=django.db.models.CharField()
        )
    )
    
    print(things.filter(bar='bar')) # This one works
    print(things.exclude(bar='bar')) # This one doesn't 
    return django.http.HttpResponse(str(things))
    