"""
XXX. Adding .sum( field ) to models

Creates a SELECT SUM( fieldname ) ... query
"""

from django.db import models

class Article(models.Model):
    headline = models.CharField(maxlength=100)
    pub_date = models.DateTimeField()
    views = models.IntegerField()

    def __str__(self):
        return self.headline

API_TESTS = """
# Create a few articles.
>>> from datetime import datetime
>>> a = Article(headline='Area man programs in Python', pub_date=datetime(2005, 7, 28), views=77)
>>> a.save()

>>> a = Article(headline='Django 0.95 Released', pub_date=datetime(2006, 8, 04), views=223)
>>> a.save()

>>> a = Article(headline='Django accepted as framework of choice', pub_date=datetime(2006, 8, 04), views=700)
>>> a.save()

>>> sum = Article.objects.all().sum( 'views' )
>>> int( sum ) == 1000
True

>>> sum = Article.objects.all().filter( pk=1 ).sum( 'views' )
>>> int( sum ) == 77
True

>>> sum = Article.objects.all().filter( pub_date__year=2006 ).sum( 'views' )
>>> int( sum ) == 923
True

>>> sum = Article.objects.all().filter( pub_date__year=2006 ).sum( 'views' )
>>> int( sum ) == 1123923
False
"""
