# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from django.db import models, migrations, transaction
import datetime

# Python code to calculate call end times, because we can't do it in SQL
CHUNK_SIZE = 1000
UPDATE_FIELDS = ['call_end_utc']
def calculate_end_time(apps, schema_editor):
    transaction.set_autocommit(False)
    Cdr = apps.get_model("phx", "Cdr")
    last_chunk = 0
    new_items = True
    while new_items:
        new_items = False
        cdr = None
        for cdr in Cdr.objects.all()[last_chunk:last_chunk+CHUNK_SIZE]:
            if cdr.call_end_utc is None:
                cdr.call_end_utc = cdr.call_utc + datetime.timedelta(seconds=cdr.exact_call_duration)
                cdr.save(update_fields=UPDATE_FIELDS)
                transaction.commit()
        if cdr is not None:
            new_items = True
            last_chunk += CHUNK_SIZE

def do_nothing(apps, schema_editor):
    pass  # we need a callable for the reverse direction, so we use this.


class Migration(migrations.Migration):

    dependencies = [
        ('phx', '0007_cdr_call_end_utc'),
    ]

    operations = [
        migrations.RunPython(calculate_end_time, do_nothing, atomic=False)

        #migrations.AlterField(
        #    model_name='cdr',
        #    name='call_end_utc',
        #    field=models.DateTimeField(db_index=True, help_text='UTC Timestamp when call disconnected.'),
        #),
    ]
