from django.conf.urls.defaults import *
from django.conf import settings
from django.contrib import admin
admin.autodiscover()

from bug.views import *
from bug.models import Bug

urlpatterns = patterns('',
    url(r'^bug/$', bug_view, name='bug_view'),
    url(r'^bug/(?P<id>\d+)/$', bug_view,  name='bug_view_id'),
	url(r'^bug/archive/(?P<year>\d+)/(?P<month>\w+)/(?P<day>\d+)/$', 
		'django.views.generic.date_based.archive_day', {
			'date_field':'submitted',
			'queryset':Bug.objects.all(), 
			'template_name':'bug_view.html'
		}, name='bug_archive'),

    url(r'^admin/', include(admin.site.urls)),
)

if settings.DEBUG:
    urlpatterns += patterns('',
        (r'^site-media/(?P<path>.*)$', 'django.views.static.serve',
         {'document_root': settings.MEDIA_ROOT}),
        (r'^media/(?P<path>.*)$', 'django.views.static.serve',
         {'document_root': settings.ADMIN_MEDIA_ROOT}),
    )



