from django.db import models
import datetime

class Bug(models.Model):
    title = models.CharField(blank=False, max_length=80)
    description = models.CharField(blank=False, max_length=160)
    submitted = models.DateField(default=datetime.datetime.today)
    
    @models.permalink
    def get_absolute_url(self):
        return "/bug/%i/" % self.id
    
    def __unicode__(self):
        return u'%s: %s' % (str(self.title), str(self.submitted))

