from django.db import models
from django.contrib.auth.models import User


class Client(models.Model):
    """ Stores a single client entry """
    first_name = models.CharField(max_length=50)
    last_name = models.CharField(max_length=50)
    street = models.CharField(max_length=100)
    street_alt = models.CharField(max_length=100, blank=True)
    city = models.CharField(max_length=50)
    prov = models.CharField(max_length=2)
    postal = models.CharField(max_length=12, blank=True)
    created = models.DateTimeField(auto_now_add=True)
    updated = models.DateTimeField(auto_now=True)

    class Meta:
        ordering = ['last_name', 'first_name']

    def get_absolute_url(self):
        return u'/client/%d' % self.id

    def __unicode__(self):
        """
        Returns the client's first and last name
        :return:
        """
        return u"%s %s" % (self.first_name, self.last_name)


class ClientPhone(models.Model):
    client = models.ForeignKey(Client)
    type = models.CharField(max_length=10)
    phone = models.CharField(max_length=15)

    def __unicode__(self):
        return self.phone


class ClientEmail(models.Model):
    client = models.ForeignKey(Client)
    type = models.CharField(max_length=10)
    email = models.EmailField()
    accepts_emails = models.BooleanField(default=False)

    def __unicode__(self):
        return self.email


class ClientNote(models.Model):
    client = models.ForeignKey(Client)
    created = models.DateTimeField(auto_now_add=True)
    note = models.TextField()
    creator = models.ForeignKey(User)


class ClientDiscount(models.Model):
    client = models.ForeignKey(Client)
    reason = models.CharField(max_length=10)
    amount = models.DecimalField(max_digits=4, decimal_places=2)
    created = models.DateTimeField(auto_now_add=True)
    creator = models.ForeignKey(User)