from django.template.loader import get_template
from django.test import TestCase
from django.test.signals import template_rendered


class TestTemplateInheritance(TestCase):
    def test_inherit_template(self):
        self.template_rendered = False
        def signal_receiver(template, context, **kwargs):
            if template.name == 'base.html':
                self.template_rendered = True

        template_rendered.connect(signal_receiver)

        template = get_template('derived.html')
        template.render()

        self.assertTrue(self.template_rendered)
