# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


def fetch_main_person(apps, schema_editor):
    MainPerson = apps.get_model('bugapp', 'MainPerson')
    person_or_none = MainPerson.objects.first()


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Person',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.IntegerField(default=None, null=True)),
            ],
            bases=(models.Model,),
        ),

        migrations.CreateModel(
            name='MainPerson',
            fields=[
                ('person_ptr', models.OneToOneField(parent_link=True, auto_created=True, primary_key=True, serialize=False, to='bugapp.Person')),
            ],
            bases=('bugapp.person',),
        ),

        migrations.CreateModel(
            name='PersonPreferences',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('person', models.OneToOneField(related_name='preferences', to='bugapp.Person')),
            ],
            bases=(models.Model,),
        ),

        migrations.RemoveField(
            model_name='person',
            name='name',
        ),

        migrations.RunPython(fetch_main_person, lambda apps, schema_editor: None),
    ]
