from django.test import TestCase
import enrollment.models as em
# Create your tests here.

class QuerysetAndAssertionError(TestCase):
    def setUp(self):
        year = em.Year.objects.create()

        anth100 = year.course_set.create(department='ANTH',number=100)
        math101 = year.course_set.create(department='MATH',number=101)

        s1 = year.student_set.create(number=1)
        s2 = year.student_set.create(number=2)

        s1.courses = [math101,anth100]
        s2.courses = [math101]

    def test_and(self):
        year = em.Year.objects.last()

        math101 = year.course_set.get(department='MATH',number=101)
        anth100 = year.course_set.get(department='ANTH',number=100)

        result = math101.student_set.all() & year.student_set.exclude(courses__in=[anth100])
        # in Django 1.8.3:
        # Traceback (most recent call last):
        #   File "/home/kevmitch/projects/apprentice/and_assertion_error/enrollment/tests.py", line 24, in test_and
        #     result = math101.student_set.all() & year.student_set.exclude(courses__in=[anth100])
        #   File "/home/kevmitch/projects/apprentice/apprentice/env/local/lib/python2.7/site-packages/django/db/models/query.py", line 211, in __and__
        #     combined.query.combine(other.query, sql.AND)
        #   File "/home/kevmitch/projects/apprentice/apprentice/env/local/lib/python2.7/site-packages/django/db/models/sql/query.py", line 556, in combine
        #     w.relabel_aliases(change_map)
        #   File "/home/kevmitch/projects/apprentice/apprentice/env/local/lib/python2.7/site-packages/django/db/models/sql/where.py", line 285, in relabel_aliases
        #     child.relabel_aliases(change_map)
        #   File "/home/kevmitch/projects/apprentice/apprentice/env/local/lib/python2.7/site-packages/django/db/models/sql/where.py", line 287, in relabel_aliases
        #     self.children[pos] = child.relabeled_clone(change_map)
        #   File "/home/kevmitch/projects/apprentice/apprentice/env/local/lib/python2.7/site-packages/django/db/models/lookups.py", line 185, in relabeled_clone
        #     new.rhs = new.rhs.relabeled_clone(relabels)
        #   File "/home/kevmitch/projects/apprentice/apprentice/env/local/lib/python2.7/site-packages/django/db/models/sql/query.py", line 329, in relabeled_clone
        #     clone.change_aliases(change_map)
        #   File "/home/kevmitch/projects/apprentice/apprentice/env/local/lib/python2.7/site-packages/django/db/models/sql/query.py", line 787, in change_aliases
        #     assert set(change_map.keys()).intersection(set(change_map.values())) == set()
        # AssertionError
