(testenv)kondou:project/ (master) $ cat project/models/user_model.py
from django.contrib.auth.models import AbstractBaseUser, BaseUserManager, Group, PermissionsMixin
from django.core import mail, validators
from django.conf import settings
from django.core.urlresolvers import reverse
from django.db import models
from django.utils import timezone, translation
from django.utils.translation import ugettext_lazy
import re

from project.dbutilities import date_in_one_month


class UserManager(BaseUserManager):
    def create_user(self, username, email, password=None, to_activate=False, languagecode="en-us"):
        pass

    def create_superuser(self, username, email, password):
        pass

class User(PermissionsMixin, AbstractBaseUser):
    class Meta:
        get_latest_by = "date_joined"

    username = models.CharField(
        ugettext_lazy('username'), max_length=30, unique=True,
        help_text=ugettext_lazy('30 characters or less. Letters, numbers and ./+/-/_ characters are allowed'),
        validators=[
            validators.RegexValidator(re.compile('^[\w.+-]+$'), ugettext_lazy('Invalid username.'), 'invalid')
        ]
    )
    displayname = models.CharField(max_length=150, blank=True)
    email = models.EmailField()
    email_bounced = models.BooleanField(
        default=False,
        help_text="Whether a mail to this email bounced, and no more mail should be sent to this"
    )
    email_complained = models.BooleanField(
        default=False,
        help_text="Whether this email complained, meaning no mail, other than pwreset mails should be sent"
    )
    banned = models.BooleanField(default=False)
    active = models.BooleanField(default=True)
    date_joined = models.DateField(auto_now_add=True)
    lastpwchange = models.DateTimeField(auto_now_add=True)
    follows = models.ManyToManyField('self', symmetrical=False, related_name="following")
    ignores = models.ManyToManyField(
        'self', symmetrical=False, related_name="ignoring",
        help_text=ugettext_lazy(
            "Ignored means you don't get messages anymore from this user, but for them their messages seem to arrive."
        )
    )
    blocks = models.ManyToManyField(
        'self', symmetrical=False, related_name="blocking",
        help_text=ugettext_lazy(
            "Blocked means you don't get messages anymore from this user and they will see a \"You're blocked\" "
            "message on trying to message you. They also can't comment on your gallerys either."
        )
    )
    monetization_enabled = models.BooleanField(default=False)
    monetization_in_queue = models.BooleanField(default=False)
    countrycode = models.CharField(max_length=10, blank=True)
    languagecode = models.CharField(max_length=10, blank=True)
    payment_credit = models.FloatField(default=0)
    avatar = models.CharField(max_length=10, unique=True, blank=True, null=True)
    default_moderators = models.ManyToManyField('self', related_name="default_moderators")
    uploader = models.BooleanField(default=False)
    unread_messages = models.IntegerField(default=0)

    USERNAME_FIELD = 'username'
    REQUIRED_FIELDS = ['email']
    objects = UserManager()

    # Required methods

    def get_full_name(self):
        if self.displayname != '':
            return self.displayname
        else:
            return self.username

    def get_short_name(self):
        return self.username

    def is_active(self):
        return self.active

    # -- Own methods --

    # Administrative

    def is_banned(self):
        return self.banned

    def set_password(self, raw_password):
        self.lastpwchange = timezone.now()
        super().set_password(raw_password)

    def set_countrycode(self, code):
        self.countrycode = code
        self.save()

    def set_languagecode(self, code):
        self.languagecode = code
        self.save()

    # Other

    def get_url(self):
        return reverse('userview', kwargs={'username': self.username})


class AccountActivation(models.Model):
    user = models.OneToOneField(User, primary_key=True)
    token = models.CharField(
        max_length=10, unique=True,
        validators=[validators.RegexValidator(
            re.compile('^[abcdefghijklmnopqrstuvwxyz\d]{10}$'), 'Invalid key', 'invalid'
        )]
    )
    used = models.BooleanField(default=False)
    expiry = models.DateField(default=date_in_one_month)