from django.db import models
from django.contrib.auth.models import AbstractBaseUser
from django.contrib.auth.models import BaseUserManager
from django.contrib.auth.models import PermissionsMixin
from django.contrib.auth.models import Group as OriginalGroup


class Group(OriginalGroup):
    class Meta:
        proxy = True


class UserManager(BaseUserManager):
    def get_by_natural_key(self, identifier):
        return self.get(identifier=identifier)

class User(AbstractBaseUser, PermissionsMixin):
    identifier = models.CharField(max_length=255, unique=True)
    first_name = models.CharField(max_length=40, null=True, blank=True)
    last_name = models.CharField(max_length=40, null=True, blank=True)
    email = models.EmailField(max_length=255, unique=True, null=True)
    is_active = models.BooleanField(default=True)

    objects = UserManager()

    USERNAME_FIELD = 'identifier'

    def __str__(self):
        return self.get_full_name()
 
    def get_full_name(self):
       return '%s %s' % (self.first_name, self.last_name)

    def get_short_name(self):
        return self.first_name

    def natural_key(self):
        return (self.identifier,)
