#!/bin/sh

if [ "$VIRTUAL_ENV" = "" ] ; then
  echo "Please run in a fresh virtualenv"
  exit 1
fi
set -ex

pip install -r requirements.txt
dropdb migrationdb || true
createdb migrationdb

export PYTHONPATH=.
export DJANGO_SETTINGS_MODULE=settings

# start with initial models
rm -rf app/migrations

cp app/models1.py app/models.py
rm app/*.pyc
django-admin.py makemigrations app
django-admin.py migrate

# Now rename the foreignkey field
cp app/models2.py app/models.py
rm app/*.pyc
echo "Answer the next question Y"
django-admin.py makemigrations app
django-admin.py migrate

# Now add a new fk with the original name
cp app/models3.py app/models.py
rm app/*.pyc
django-admin.py makemigrations app
django-admin.py migrate
