# UUID Dumpdata

### Summary

Unable to serialize UUIDField when running dumpdata with JSON format.

### Requirements

- PostgreSQL database named `uuid_dumpdata`
    - `postgres://127.0.0.1:5432/uuid_dumpdata`

### Steps

- Run `migrate --noinput`
- Run `createtestdata`
- Run `dumpdata --format=json`

### Expected Result

- The data is successfully dumped

### Actual Result

- An error occurs `CommandError: Unable to serialize database: UUID('4662a465-0184-4e5e-8111-4f425130425e') is not JSON serializable`

### Notes

- Using XML output format `dumpdata --format=json` does not cause the error
- See `createtestdata.py` line 23 for a declared site ID
