import uuid

from django.contrib.auth.models import AbstractBaseUser, BaseUserManager, PermissionsMixin
from django.db import models


class Person(PermissionsMixin, AbstractBaseUser):
    email = models.EmailField(max_length=254, unique=True)
    id = models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True)
    first_name = models.CharField(max_length=35)
    is_active = models.BooleanField(default=True)
    is_staff = models.BooleanField(default=False)
    last_name = models.CharField(max_length=35)
    
    objects = BaseUserManager()
    
    USERNAME_FIELD = 'email'
    REQUIRED_FIELDS = ['first_name', 'last_name']
    
    def __str__(self):
        return self.get_full_name()
    
    def get_full_name(self):
        return '%(first_name)s %(last_name)s' % {'first_name': self.first_name, 'last_name': self.last_name}
    
    def get_short_name(self):
        return self.first_name
