from django.contrib.auth import get_user_model
from django.core.management import base


class Command(base.BaseCommand):
    help = 'Creates a user in the database.'
    
    def handle(self, *args, **options):
        self.stdout.write('Creating user...', ending='')
        self.stdout.flush()
        user_model = get_user_model()
        user, created = user_model.objects.get_or_create(email='john@lennon.com', defaults={'first_name': 'John', 'last_name': 'Lennon'})
        if created:
            user.set_password('django')
            user.save()
        self.stdout.write(self.style.MIGRATE_SUCCESS(' OK'))
