# UUID User

### Summary

When using the new `UUIDField` in Django 1.8 for the `id` of a custom User model, a session fails to be created and a `TypeError` exception is thrown when attempting to log in.

### Requirements

- PostgreSQL database named `uuid_user`
    - `postgres://127.0.0.1:5432/uuid_user`

### Steps

- Apply the migrations
- Run the management command `createuser`
- Run the development server
- Now attempt to log in using the following credentials
    - Email: `john@lennon.com`
    - Password: `django`
 
### Expected Result

- The log in is successful and you’re taken to the home page

### Actual Result

- An exception is thrown, I believe related to storing the session data

```
TypeError at /login/
UUID('314cb5d6-593f-48f5-b1af-fadedde123d3') is not JSON serializable
```
