from django.db import models

class Post(models.Model):
	title = models.CharField(maxlength=100)
	slug = models.SlugField(prepopulate_from=("title",))
	post_date = models.DateTimeField(auto_now_add=True)
	
	class Admin:
		pass
		
	def get_absolute_url(self):
		return "/blog/%s/%s/" % (self.post_date.strftime("%Y/%b/%d").lower(), self.slug)