from django.conf.urls.defaults import *

from blog.models import Post

info_dict = {
	'queryset': Post.objects.all(),
	'date_field': 'post_date',
}

list_dict = {
	'queryset': Post.objects.order_by('-post_date'),
}

urlpatterns = patterns('django.views.generic',
	(r'^blog/(?P<year>\d{4})/(?P<month>[a-z]{3})/(?P<day>\w{1,2})/(?P<slug>[-\w]+)/$', 'date_based.object_detail', dict(info_dict, slug_field='slug')),
	(r'^blog/(?P<year>\d{4})/(?P<month>[a-z]{3})/(?P<day>\w{1,2})/$', 'date_based.archive_day', info_dict),
	(r'^blog/(?P<year>\d{4})/(?P<month>[a-z]{3})/$', 'date_based.archive_month', info_dict),
	(r'^blog/(?P<year>\d{4})/$', 'date_based.archive_year', info_dict),
	(r'^/?$', 'list_detail.object_list', list_dict),
	
	(r'^admin/', include('django.contrib.admin.urls')),
)