from django.db import models
from django.contrib.contenttypes.models import ContentType
from django.contrib.contenttypes.generic import GenericForeignKey

class MyModel(models.Model):
    content_type = models.ForeignKey(ContentType)
    object_id = models.PositiveIntegerField()
    my_field = GenericForeignKey()

class MyList(models.Model):
    name = models.TextField(max_length=50)
    active = models.BooleanField(default= True)

    def __str__(self):
        return self.name

class MyItem(models.Model):
    name = models.TextField(max_length=50)
    mylist = models.ForeignKey(MyList, limit_choices_to={'active': True})

    def __str__(self):
        return self.name
