from django.test import TestCase
from django.db import models


class DemonstrateBug(TestCase):
    # Even though we define Class in two separate scopes,
    # the definition of Class from the test run first
    # eclipses the definition of Class from the test
    # run second, when inheriting from models.Model.
    
    def test_attribute_is_foo(self):
        # declare Class with attribute="foo"
        class Class(models.Model):
            attribute = "foo"

        self.assertEqual(Class.attribute, "foo")

    def test_attribute_is_bar(self):
        # declare Class with attribute="bar"
        class Class(models.Model):
            attribute = "bar"

        self.assertEqual(Class.attribute, "bar")

    # Note: this bug no longer occurs if instead of inheriting
    # from models.Model, we directly set the metaclass to
    # models.base.ModelBase, so the bug probably exists somewhere
    # in the Model class.
