from django.conf.urls import patterns, include, url
from django.contrib import admin
from django.contrib.sitemaps import GenericSitemap
from App.models import Blog


info_dict1 = {
    'queryset': Blog.objects.all(),
    'date_field': 'blogdate',
}

sitemaps = {
    'blog': GenericSitemap(info_dict1, priority=0.6),
}

admin.autodiscover()

urlpatterns = patterns('',
                       url(r'^admin/', include(admin.site.urls)),
                       url(r'^$', 'App.views.index'),
                       url(r'^sitemap\.xml$', 'django.contrib.sitemaps.views.sitemap', {'sitemaps': sitemaps}),
)
