from datetime import datetime
from django.db import models


class Blog(models.Model):
    slug = models.TextField(max_length=30)
    comment = models.TextField(max_length=2000)
    blogdate = models.DateField(auto_now=True, auto_now_add=True, default=datetime.now())

    def __unicode__(self):
        return self.slug

    def get_absolute_url(self):
        return '/' + self.slug

    class Meta:
        db_table = 'blog'
