from django import get_version
from django.core.management.sql import sql_create
from django.core.management.base import BaseCommand
from django.db import connection
from django.core.management.color import no_style

class Command(BaseCommand):

    def handle(self, *args, **options):
        version = get_version()
        print version
        if version.startswith('1.6'):
            from django.db import models
            sql = sql_create(models.get_app('repro_app'), no_style(), connection)
            print '\n'.join(sql)

        elif version.startswith('1.7'):
            from django.apps import apps
            sql = sql_create(apps.get_app_config('repro_app'), no_style(), connection)
            print '\n'.join(sql)

