import logging, re
from pprint import pformat
from django.conf import settings
from mockup import mockup
from dj_kunde.contrib.view_test.context_keeper import get_context

class TestGhostWriter:
    def __init__(self):
        self.url_filter = re.compile(settings.TEST_URL_FILTER)
        self.logger = logging.getLogger("test.write")

    def process_response(self, request, response):
        if self.url_filter.search(request.path):
            self.logger.debug("# --------------------------------------------------------------------")
            self.logger.debug("# %s %s" % (request.META["REQUEST_METHOD"], request.path))
            if request.GET or request.POST:
                self.logger.debug("GET = MultiValueDict(%s)", pformat(dict(request.GET.lists())))
                self.logger.debug("POST = MultiValueDict(%s)", pformat(dict(request.POST.lists())))
                self.logger.debug("response, context = runner.get_response(%r, %r, GET, POST)" %
                                  (request.path, request.META["REQUEST_METHOD"]))
            else:
                self.logger.debug("response, context = runner.get_response(%r, %r, {}, {})" %
                                  (request.path, request.META["REQUEST_METHOD"]))
            self.logger.debug("assert runner.check_response(response, %s)", pformat(mockup(response)))
            if response.status_code < 300:
                self.logger.debug("assert runner.check_context(response, context, %s)", pformat(get_context()))
        return response

