from django.db import models
from django.contrib.auth.models import AbstractBaseUser, PermissionsMixin, BaseUserManager
from djtest.basemodel import BaseModel

class Employee(AbstractBaseUser, PermissionsMixin, BaseModel):
	username = models.CharField("Username", max_length = 50, unique = True, db_index = True)
	email = models.EmailField(max_length = 254, default = "", blank = True)
	is_active = models.BooleanField("active", default = True)
	
	direct_phone = models.CharField(max_length = 30, default = "", blank = True)
	phone_ext = models.CharField(max_length = 10, default = "", blank = True)
	
	store = models.ForeignKey('eggs.Store', related_name = 'employees')
	
	objects = BaseUserManager()
	
	USERNAME_FIELD = 'username'
	REQUIRED_FIELDS = ['email']
	
	def get_groups_query_string(self):
		return 'groups'

class Eggs(BaseModel):
	employee = models.ForeignKey('spam.Employee')
	cheese = models.ForeignKey('cheese.Cheese')
