from __future__ import unicode_literals
from django.db import models
from django.contrib.auth.models import User
from testproject.properties.models import Property
from datetime import datetime, date, timedelta
from django.core.urlresolvers import reverse
from testproject.reports.models import ReportSchedule
from testproject.contractors.models import Contractor
from django.utils import timezone
import datetime


class Inspector(models.Model):
    account = models.ForeignKey(User)


class InspectionItemType(models.Model):
    pass


class InspectionItem(models.Model):
    type = models.ForeignKey(InspectionItemType)
    property = models.ForeignKey(Property)
    report_schedule = models.ManyToManyField(ReportSchedule, blank=True, null=True)
    contractor = models.ForeignKey(Contractor, null=True, blank=True)
    failures = models.ManyToManyField('InspectionItemFailure', blank=True, null=True, verbose_name="Observations")
    inspected_by = models.ForeignKey(Inspector, blank=True, null=True)


class InspectionItemFailure(models.Model):
    type = models.ForeignKey(InspectionItemType, null=True, blank=True)


class InspectionItemFlag(models.Model):
    pass

class InspectionItemPreset(models.Model):
    """ Presets provide a way to group a bunch of items for quick addition to a properties reportschedule. """
    author = models.ForeignKey(User)
    items = models.ManyToManyField(InspectionItemType)
