from __future__ import unicode_literals
from django.db import models
from django.contrib.auth.models import User
from django.core.urlresolvers import reverse
from testproject.properties.models import Property
from testproject.contractors.models import Contractor
import datetime
from django.utils import timezone

class ReportType(models.Model):
    pass

class ReportSchedule(models.Model):
    property = models.ForeignKey(Property)
    type = models.ForeignKey(ReportType, verbose_name="Report type")


class Report(models.Model):
    inspector = models.ForeignKey('inspections.Inspector', blank=True, null=True)
    author = models.ForeignKey(User, blank=True, null=True)

    type = models.ForeignKey(ReportType)
    property = models.ForeignKey(Property)
    schedule = models.ForeignKey(ReportSchedule, blank=True, null=True)


class ReportItem(models.Model):
    type = models.ForeignKey('inspections.InspectionItemType')

    inspection_item = models.ForeignKey('inspections.InspectionItem', help_text="The properties InspectionItem this ReportItem corresponds to.")
    report = models.ForeignKey(Report)
    property = models.ForeignKey(Property)

    contractor = models.ForeignKey(Contractor, blank=True, null=True)
    failures = models.ManyToManyField('inspections.InspectionItemFailure', blank=True, null=True)

