from django.db import models
from django.contrib.auth.models import User

# Create your models here.
class Profile(models.Model):
   user = models.OneToOneField(User)

   def  __unicode__(self):
      return u'%s' % self.user.username


class Team(models.Model):
   #members  = models.ManyToManyField(Profile, related_name='teams')
   #managers = models.ManyToManyField(Profile, related_name='manages')
   #leader   = models.ForeignKey(Profile, related_name='leads')
   members  = models.ManyToManyField(User, related_name='teams')
   managers = models.ManyToManyField(User, related_name='manages')
   leader   = models.ForeignKey(User, related_name='leads')

   def __unicode__(self):
      return u'Team Number %s' % self.id 
