from django.db import models
from django.db.models.functions import Cast, Concat, Right


class TestEntity(models.Model):
    some_property = models.TextField()

    class Meta:
        #ordering = ('some_property',)
        ordering = (
            Cast(models.Func(models.F('some_property'), models.Value('^\d+'), function='SUBSTRING'), models.IntegerField()),
            Right(Concat(models.Value('00000'), models.F('some_property')), models.Value(5))
        )
