class SampleModelRouter(object):
    """
    A router to control all database operations on models.
    """

    def db_for_read(self, model, **hints):
        """
        Attempts to read go to game db.
        """
        if model._meta.app_label == 'SampleModel':
            return 'second_db'
        return None

    def db_for_write(self, model, **hints):
        """
        Attempts to write go to game db.
        """
        if model._meta.app_label == 'SampleModel':
            return 'second_db'
        return None

    def allow_migrate(self, db, model):
        """
        Make sure the app only appears on the right db.
        """
        if db == 'second_db':
            return model._meta.app_label == 'SampleModel'
        elif model._meta.app_label == 'SampleModel':
            return False
        return None
