from django.db.models import CharField, ManyToManyField, Model


class Filler(Model):
    name = CharField(max_length=40)
    class Meta:
        abstract=True

class Ring(Filler):
    "...to bring them all and in the darkness bind them"
    pass


class One(Filler):
    "this will test for #22975 bug - model name changed, db_table keeps it the same"
    pass


class Two(Filler):
    "this will test for the bug (not reported?) that's implied by #22975, just ignores db_table?"
    class Meta:
        db_table = "x_twosies"


class Three(Filler):
    "this will be the new bug - M2M field name changed, db_table keeping old table name ignored"
    ring = ManyToManyField("Ring")


class Four(Filler):
    "this will test implicitly suspected bug, original db_table ignored, too"
    ringsie = ManyToManyField("Ring", db_table="x_four_ring")

